<?php
class AppController extends Controller {
	var $helpers = array('Html', 'Form', 'Session', 'Javascript');
	var $components = array('Auth', 'Session');
	//var $components = array('Auth');

	function beforeFilter() {

		Configure::load('settings');

		$post_max_size = Configure::read('PHP.post_max_size');
		$max_execution_time = Configure::read('PHP.max_execution_time');
		$max_input_time = Configure::read('PHP.max_input_time');
		$memory_limit = Configure::read('PHP.memory_limit');
		$upload_max_filesize = Configure::read('PHP.upload_max_filesize');

		ini_set('post_max_size', $post_max_size);
		ini_set('max_execution_time', $max_execution_time);
		ini_set('max_input_time', $max_input_time);
		ini_set('memory_limit', $memory_limit);
		ini_set('upload_max_filesize', $upload_max_filesize);

		Security::setHash('md5');
		// using Auth for other model
		$this->Auth->userModel = 'SppUser';

		// set field for username and password
		$this->Auth->fields = array('username' => 'user_name', 'password' => 'user_pwd');
			
		// set condition when login
		//$this->Auth->userScope = array('User.status' => 'active');
		$this->Auth->loginAction = array('admin' => false, 'controller' => 'sppusers', 'action' => 'login');
		$this->Auth->loginError = "アカウントまたはパスワードに誤りがあります";
		$this->Auth->loginRedirect = array("controller" => "sppusers", "action" => "menu");
			
		$this->Auth->authorize = 'controller';
			
		$this->set('title_for_layout', $this->params['controller'] . ' - ' . $this->params['action']);

	}

	function beforeRender() {
		$this->set('user', $this->Auth->user());
	}

	function isLoggedUser() {
		return $this->Auth->user();
	}

	function getUserRole($userId) {
		$this->loadModel('SppUser');
		$result = array(
			'achievement_management'        => 0,
			'support'     => 0,
			'system_management'     => 0,
		);
		if(!empty($userId)) {
			$user = $this->SppUser->findById($userId);
			if(!empty($user)) {
				foreach($user['SppRole'] as $role) {
					if($role['role_code'] == Configure::read('ROLE.ACHIEVEMENT_MANAGEMENT')) {
						$result['achievement_management'] = 1;
					} else if($role['role_code'] == Configure::read('ROLE.SUPPORT')) {
						$result['support'] = 1;
					} else if ($role['role_code'] == Configure::read('ROLE.SYSTEM_MANAGEMENT')) {
						$result['system_management'] = 1;
					}
				}
			}
		}
		return $result;
	}

	function getUserRoleName($userId){
		$this->loadModel('SppUser');
		$return_roles = '';
		if(!empty($userId)) {
			$user = $this->SppUser->findById($userId);
			
			foreach($user['SppRole'] as $role) {
				if($role['role_code'] == Configure::read('ROLE.ACHIEVEMENT_MANAGEMENT')) {
					$return_roles = '成績管理';
				} else if($role['role_code'] == Configure::read('ROLE.SUPPORT')) {
					$return_roles = empty($return_roles) ? 'サポート': $return_roles . ' - サポート';
				} else if ($role['role_code'] == Configure::read('ROLE.SYSTEM_MANAGEMENT')) {
					$return_roles = empty($return_roles) ? 'システム管理': $return_roles . ' - システム管理';
				}
			}
		}
		return $return_roles;
	}

	function isSystemManagement(){
		return $this->checkRole(Configure::read('ROLE.SYSTEM_MANAGEMENT'));
	}

	function isAchievementManagement(){
		return $this->checkRole(Configure::read('ROLE.ACHIEVEMENT_MANAGEMENT'));
	}

	function isSupporter(){
		return $this->checkRole(Configure::read('ROLE.SUPPORT'));
	}

	function checkRole($role_code){
		$this->loadModel('SppUser');
		$session = $this->Session->read();
		if(!isset($session['Auth'])  || !isset($session['Auth']['SppUser']) ) {
			$this->redirect(array('controller'=>'sppusers','action' => 'login'));
		}
		$id = $session['Auth']['SppUser']['id'];
		if (!empty($id)) {
			$user = $this->SppUser->findById($id);
			if(!empty($user)) {
				foreach($user['SppRole'] as $role) {
					if ($role['role_code'] == $role_code) {
						return true;
					}
				}
			}else{
				$this->redirect(array('controller'=>'sppusers','action' => 'login'));
			}
		}else{
			$this->redirect(array('controller'=>'sppusers','action' => 'login'));
		}
		return false;
	}

	function checkUserLogin(){
		$session = $this->Session->read();
		if(!isset($session['Auth'])  || !isset($session['Auth']['SppUser']) ) {
			$this->redirect(array('controller'=>'sppusers','action' => 'login'));
		}
		return true;
	}
	function checkExitsUser($userName) {
		$user = $this->SppUser->find('first', array(
                'conditions' => array(
                    'SppUser.user_name' => $userName
		),
                'recursive' => -1
		));
		if(!empty($user)) {
			return true;
		} else {
			return false;
		}
	}

	function serialNumber($number,$length)
	{
		$lengthNumber = strlen($number);
		$temp = '';
		$effect = $length - $lengthNumber;
		if($effect > 0){
			for($i=0;$i<$effect;$i++){
				$temp.='0';
			}
			return $temp.$number;
		}else{
			return $number;
		}
	}

	function checkEmptyWithoutZero($value){
		if(!isset($value)){
			return true;
		}
		$value = trim($value);
		if(empty($value)){
			if(strcmp($value,'0') == 0){
				return false;
			}
			return true;
		}
		return false;
	}

    public function corsSSL() {

        Configure::load('settings');

        // Allow from any origin
//        $allowedOrigins = Configure::read('SPP_SERVER_API');
//        $wildcard = FALSE;
//        $credentials = FALSE;
//        if (isset($_SERVER['HTTP_ORIGIN']) && !in_array($_SERVER['HTTP_ORIGIN'], $allowedOrigins) && !$wildcard) {
//            exit;
//        }
//        $origin = $wildcard && !$credentials ? '*' : $_SERVER['HTTP_ORIGIN'];
//        header("Access-Control-Allow-Origin: " . $origin);
//        header('Access-Control-Allow-Origin: *');
//        header('Content-type: application/json');

        $allowedOrigins = Configure::read('SPP_SERVER_API');
        if (isset($_SERVER['HTTP_ORIGIN']) && in_array($_SERVER['HTTP_ORIGIN'], $allowedOrigins)) {

            header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
            header('Access-Control-Allow-Credentials: true');
            header('Access-Control-Max-Age: 86400');    // cache for 1 day
            header('Access-Control-Allow-Origin: *');
            header('Content-type: application/json');
        }

        // Access-Control headers are received during OPTIONS requests
        if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {

            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
                // may also be using PUT, PATCH, HEAD etc
                header("Access-Control-Allow-Methods: GET, POST, PUT, OPTIONS");

            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");

            exit(0);
        }
    }
}
?>