<?php
class LogsController extends AppController {
	var $name = "Logs";
	var $uses = array('LearningLog', 'ClientLearningInformation', 'ApplicationLearningInformation');
	
	var $error = array();
	
	function index() {
		$learning = $this->LearningLog->find('all');
		$clientLearningInformation = $this->ClientLearningInformation->find('all');
		$applicationLearningInformation = $this->ApplicationLearningInformation->find('all');
		
		debug($learning);
		debug($clientLearningInformation);
		debug($applicationLearningInformation);die;
	}
	
	function buildLog() {
		$this->layout = '';
		$this->autoRender = false;
		
		// Select distinct client_id, application_id
		$learningLogs = $this->LearningLog->find('all', array(
			'fields' => 'DISTINCT LearningLog.client_id, LearningLog.application_id'
		));
		
		// Foreach data
		foreach ($learningLogs as $value) {
			$client_id = $value['LearningLog']['client_id'];
			$app_id = $value['LearningLog']['application_id'];
			
			// Get data with client_id and $app_id
			$log = $this->LearningLog->find('all', array(
				'conditions' => array(
					'LearningLog.client_id' => $client_id,
					'LearningLog.application_id' => $app_id
				)
			));
			//debug($log);
			$timeTotal = 0;
			if(!empty($log)) {
				foreach ($log as $v) {
					$temp = explode(':', $v['LearningLog']['learning_duration']);
					$ts = ($temp[0] * 3600) + ($temp[1] * 60) + $temp[2];
					$timeTotal += $ts;
				}	
			} else {
				$this->error[] = "Don't have log record";
			}
			
			$timeTotal = date('H:i:s', $timeTotal);
			
			$logTemp = $this->LearningLog->find('all', array(
				'fields' => 'DISTINCT LearningLog.learning_date',
				'conditions' => array(
					'LearningLog.client_id' => $client_id,
					'LearningLog.application_id' => $app_id
				)
			));
			
			$dayOfUsage = count($logTemp);
			
			// Update data to client_learning_information
			$clientLearningInfo = $this->ClientLearningInformation->find('all', array(
				'conditions' => array(
					'ClientLearningInformation.client_code' => $client_id,
					'ClientLearningInformation.application_code' => $app_id
				)
			));		
			
			if(!empty($clientLearningInfo)) {
				if(!$this->ClientLearningInformation->updateAll(
					array(
						'ClientLearningInformation.learning_time_total' => "'" . $timeTotal . "'",
						'ClientLearningInformation.days_of_usage' => $dayOfUsage
					),
					array(
						'ClientLearningInformation.id' => $clientLearningInfo[0]['ClientLearningInformation']['id']
					)
				)) {
					$this->error[] = "Cannot update client learning information with id = " . $clientLearningInfo[0]['ClientLearningInformation']['id'];
				}
			} else {
				$this->error[] = "Don't have client learning information record";
			}
		}
		
		
		$clientInfo = $this->ClientLearningInformation->find('all');
		if(!empty($clientInfo)) {
			foreach($clientInfo as $item) {
				$clientNo = $item['ClientLearningInformation']['client_code'];
				$appNo = $item['ClientLearningInformation']['application_code'];

				// Get application learning information record
				$app = $this->ApplicationLearningInformation->find('all', array(
					'conditions' => array(
						'ApplicationLearningInformation.application_code' => $appNo,
						'ApplicationLearningInformation.subscription_number' => $clientNo
					)
				));
				
				if(!empty($app)) {
					// Calculate average time
					$totalTime = 0;
					$appList = $this->ClientLearningInformation->find('all', array(
						'conditions' => array(
							'ClientLearningInformation.application_code' => $appNo
						)
					));
					if(!empty($appList)) {
						foreach ($appList as $appItem) {
							$temp = explode(':', $appItem['ClientLearningInformation']['learning_time_total']);
							$ts = ($temp[0] * 3600) + ($temp[1] * 60) + $temp[2];
							$totalTime += $ts;
						}
					}
					
					$listClient = $this->LearningLog->find('all', array(
						'fields' => 'DISTINCT LearningLog.client_id',
						'conditions' => array(
							'LearningLog.application_id' => $appNo
						)
					));
					
					$test = round($totalTime / count($listClient));
					$averateTime = date('H:i:s', round($totalTime / count($listClient)));
					
					$time = 'time';
					$time0 = 0; $time1 = 0; $time2 = 0; $time3 = 0; $time4 = 0; $time5 = 0;
					$time6 = 0; $time7 = 0; $time8 = 0; $time9 = 0; $time10 = 0; $time11 = 0;
					$time12 = 0; $time13 = 0; $time14 = 0; $time15 = 0; $time16 = 0; $time17 = 0;
					$time18 = 0; $time19 = 0; $time20 = 0; $time21 = 0; $time22 = 0; $time23 = 0;					
					
					foreach ($listClient as $client) {
						$clients = $this->LearningLog->find('all', array(
							'conditions' => array(
								'LearningLog.application_id' => $appNo,
								'LearningLog.client_id' => $client['LearningLog']['client_id']
							)
						));
						if(!empty($clients)) {
							$totalClientTime = 0;
							foreach ($clients as $clientItem) {
								$temp = explode(':', $clientItem['LearningLog']['learning_duration']);
								$ts = ($temp[0] * 3600) + ($temp[1] * 60) + $temp[2];
								$totalClientTime += $ts;
							}
							// 0 < total < 1h
							
							for($i = 0; $i < 24; $i++) {
								$timeStart = $i*3600;
								$timeEnd = ($i + 1)*3600;
								if(($timeStart < $totalClientTime) && ($totalClientTime < $timeEnd)) {
									${"time{$i}"} += 1;									
								}
							}
						}
					}
					
					if(!$this->ApplicationLearningInformation->updateAll(
						array(
							'ApplicationLearningInformation.average_Learing_time' => "'" . $averateTime . "'",
							'ApplicationLearningInformation.time_usage_00' => $time0,
							'ApplicationLearningInformation.time_usage_01' => $time1,
							'ApplicationLearningInformation.time_usage_02' => $time2,
							'ApplicationLearningInformation.time_usage_03' => $time3,
							'ApplicationLearningInformation.time_usage_04' => $time4,
							'ApplicationLearningInformation.time_usage_05' => $time5,
							'ApplicationLearningInformation.time_usage_06' => $time6,
							'ApplicationLearningInformation.time_usage_07' => $time7,
							'ApplicationLearningInformation.time_usage_08' => $time8,
							'ApplicationLearningInformation.time_usage_09' => $time9,
							'ApplicationLearningInformation.time_usage_10' => $time10,
							'ApplicationLearningInformation.time_usage_11' => $time11,
							'ApplicationLearningInformation.time_usage_12' => $time12,
							'ApplicationLearningInformation.time_usage_13' => $time13,
							'ApplicationLearningInformation.time_usage_14' => $time14,
							'ApplicationLearningInformation.time_usage_15' => $time15,
							'ApplicationLearningInformation.time_usage_16' => $time16,
							'ApplicationLearningInformation.time_usage_17' => $time17,
							'ApplicationLearningInformation.time_usage_18' => $time18,
							'ApplicationLearningInformation.time_usage_19' => $time19,
							'ApplicationLearningInformation.time_usage_20' => $time20,
							'ApplicationLearningInformation.time_usage_21' => $time21,
							'ApplicationLearningInformation.time_usage_22' => $time22,
							'ApplicationLearningInformation.time_usage_23' => $time23,
						),
						array(
							'ApplicationLearningInformation.id' => $app[0]['ApplicationLearningInformation']['id']
						)
					)) {
						$this->error[] = "Cannot update application learning information with id = " . $app[0]['ApplicationLearningInformation']['id'];
					}
				}
			}
		}
	
		// Write log
		$path = APP . 'webroot' . DS . 'files' . DS . 'logs.txt';
		// get contents of a file into a string
		$handle = fopen($path, "a+");
		$msg = "\r\n------------------------------------\r\n";
		$msg .= "Logged at " . date('Y-m-d H:i:s');
		$msg .= "\r\nResult: ";
		if(!empty($this->error)) {
			foreach ($this->error as $error) {
				$msg .= $error;
			}
		} else {
			$msg  .= "Successfull";
		}
		fwrite($handle, $msg);
		fclose($handle);
		echo "Successfull";
	}
}