<?php
class SppPushMessageController extends AppController {

	var $name = 'SppPushMessage';
	var $uses = array('SppPushMessage','SppDeviceToken');
	var $helpers = array('Html', 'Form', 'Session', 'Dialog');
	var $components = array('Auth', 'Session');

	function beforeFilter() {
		parent::beforeFilter();
		$this->Auth->allow('index', 'submitMessage');
		// Load config file
		Configure::load('settings');
		if (!$this->isSystemManagement()) {
			$this->render('/elements/error');
			return;
		}
	}
	
	function index() {		
		if(isset($this->params['url']['delid'])){
        	$delid = $this->params['url']['delid'];
        	if($delid != ""){
        		$this->SppPushMessage->delete($delid,true);
        		$this->redirect(array('action' => 'index'));
			}
        }
		$messages = $this->SppPushMessage->find('all', array('order'=>'created_datetime DESC', 
								'limit'=>Configure::read('Push.display_number')));
		$this->set("messages", $messages);
        if($this->Session->read('PUSH.FILEERROR')!=null){
			$this->set("pushError", $this->Session->read('PUSH.FILEERROR'));
			$this->Session->delete('PUSH.FILEERROR');
        }
        $this->set('fullurl', FULL_BASE_URL . $this->webroot);
	}
	
	function submitMessage() {
		if(!empty($this->data)) {
			$this->SppPushMessage->create();
			// push 
			$success = 0;
			$fail = 0;
			$deviceTokens = $this->SppDeviceToken->find('all');
			$message = $this->data['SppPushMessage']['message'];
			
			// Using Autoload all classes are loaded on-demand
			require_once ROOT.DS.'plugins'.DS.'ApnsPHP'.DS.'Autoload.php';
		
			$iosDeviceTokens = array();
			$androidDeviceTokens = array();
			
			foreach ($deviceTokens as $val){
				$tokenId = $val['SppDeviceToken']['device_token'];
				if($val['SppDeviceToken']['device_type'] == 1){
					array_push($iosDeviceTokens, $tokenId);
				} else {
					array_push($androidDeviceTokens, $tokenId);		
				}
			}
			
			$iosDeviceCount = count($iosDeviceTokens);
			$iosSuccess = 0;
			if($iosDeviceCount > 0){
				$iosSuccess = $this->iosPushMessage($message, $iosDeviceTokens);
			}
			
			$androidDeviceTokenCount = count($androidDeviceTokens);
			$androidSuccess = 0;
			if($androidDeviceTokenCount > 0){
				$androidSuccess = $this->androidPushList($androidDeviceTokens, $message);
			}
			$success = $iosSuccess + $androidSuccess;
			$fail = $iosDeviceCount + $androidDeviceTokenCount - $success;
			//End push
			
			$this->data['SppPushMessage']['created_datetime'] = date('Y-m-d H:i:s');
			$this->data['SppPushMessage']['success'] = $success;
			$this->data['SppPushMessage']['fail'] = $fail;
			
			
			$this->SppPushMessage->begin();
			try{
				if ($this->SppPushMessage->save($this->data)) {
					$this->SppPushMessage->commit();
					$this->redirect(array('action'=>'index'));
				}	
			} catch (Exception $e) {
				$this->SppPushMessage->rollback();
			}
		}
	}
	
	function check() {
		Configure::write('debug', 1);
		$this->layout = 'ajax';
		$this->autoRender = false;
		
		//$msg = Configure::read('Message.ERR_PUSH_MESSAGE_LENGTH');
		if(!empty($_POST['msg'])) {
			return strlen($_POST['msg']);
		} else {
			return 0;	
		}	
	}
	
	function androidPushList($deviceTokens, $message){
		$success = 0;
		foreach($deviceTokens as $deviceToken){
			if($this->androidPush($message, $deviceToken)){
				$success++;
			}
		}
		return $success;
	}
	
	function iosPushMessage($msg, $deviceTokens){
		//////////// push success (from apnsPHP) ///////////////////////////////////////////////
		
		$certpath = Configure::read('Push.certpath');
		$push = new ApnsPHP_Push(
			//ApnsPHP_Abstract::ENVIRONMENT_SANDBOX,
			ApnsPHP_Abstract::ENVIRONMENT_PRODUCTION,			
			$certpath
		);
		
		// Set the Provider Certificate passphrase
		 $push->setProviderCertificatePassphrase(Configure::read('Push.passphrase'));
		
		// Set the Root Certificate Autority to verify the Apple remote peer
		$push->setRootCertificationAuthority(Configure::read('Push.Certification_Authority'));
		
		// Connect to the Apple Push Notification Service
		$push->connect();
		
		$success = 0;
		foreach ($deviceTokens as $deviceToken){
			// Instantiate a new Message with a single recipient
			$message = new ApnsPHP_Message($deviceToken);
			
			// Set a custom identifier. To get back this identifier use the getCustomIdentifier() method
			// over a ApnsPHP_Message object retrieved with the getErrors() message.
			$message->setCustomIdentifier("Message-Badge-3");
			
			// Set a message
			$message->setText($msg);
			
			// Play the default sound
			$message->setSound();
			
			// Set another custom property
			$message->setCustomProperty('acme3', array('bing', 'bong'));
			
			// Set the expiry value to 30 seconds
			$message->setExpiry(30);
			
			// Add the message to the message queue
			$push->add($message);

			$success += 1;
		}
		// Send all messages in the message queue
		$push->send();
		
		// Disconnect from the Apple Push Notification Service
		$push->disconnect();
		
		/////////////////////////////////////////////////////
		// Instanciate a new ApnsPHP_Feedback object
		$feedback = new ApnsPHP_Feedback(
			//ApnsPHP_Abstract::ENVIRONMENT_SANDBOX,
			ApnsPHP_Abstract::ENVIRONMENT_PRODUCTION,
			$certpath
		);
		
		// Connect to the Apple Push Notification Feedback Service
		$feedback->connect();
		
		$aDeviceTokens = $feedback->receive();
		if (!empty($aDeviceTokens)) {
			//delete return device token
			$this->SppDeviceToken->begin();
			try{
				if ($this->SppDeviceToken->deleteByTokens($aDeviceTokens)) {
					$this->SppDeviceToken->commit();
				}	
			} catch (Exception $e) {
				$this->SppDeviceToken->rollback();
			}
			$success = $success - count($aDeviceTokens);
		}
		
		// Disconnect from the Apple Push Notification Feedback Service
		$feedback->disconnect();
		
		return $success;
		
	}
	
	private function openSocket(&$fp, &$ctx, &$size){
		// Open a connection to the APNS server
		$fp = stream_socket_client(
		Configure::read('Push.apns'), $err,
		$errstr, 60, STREAM_CLIENT_CONNECT|STREAM_CLIENT_PERSISTENT, $ctx);
		
		stream_set_blocking ($fp, 0);
		
		$size = 0;
	}
	
	/**
	 * Push message to Android device
	 * @param $message
	 * @param $deviceToken
	 */
	function androidPush($message, $deviceToken){
		//request url
		$url = Configure::read('Push.android');
		 
		//your api key
		$apiKey = Configure::read('Push.androidapikey');
		 
		//registration ids
		$registrationIDs = array($deviceToken);
		 
		//payload data
		$data   = array('message' => $message);
		 
		$fields = array('registration_ids' => $registrationIDs,
		                'data' => $data);
		 
		//http header
		$headers = array('Authorization: key=' . $apiKey,
		                 'Content-Type: application/json');
		 
		//curl connection
		$ch = curl_init();
		 
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true );
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
		 
		$result = curl_exec($ch);
		 
		curl_close($ch);
		
		$result = json_decode($result, true);
		if($result['success'] == 1){
			return true;
		} else {
			return false;
		}
	}

}
?>
