<?php
define("SEPARATE_KEY", "|");
class SppTimelineContentController extends AppController
{
    var $name    = 'SppTimelineContent';
    var $helpers = array('Html', 'Form', 'Session', 'Form', 'Dialog', 'pass4v');
    var $uses    = array('SppTimelineContent','SppTag','SppTopImage');
    var $components  = array('RequestHandler', 'Auth', 'Session', 'Pass4v');
	var $paginate    = array();
	
	
    function beforeFilter()
    {
		parent::beforeFilter();
        $this->Auth->allow('add', 'index', 'edit');
		// check session and role
		if(!$this->isSystemManagement()){
			$this->render('/elements/error');
			return;
		}
		
    }

    function index()
    {
        if(isset($this->params['url']['delid'])){
        	$delid = $this->params['url']['delid'];
        	if($delid != ""){
                $timeline_content = $this->SppTimelineContent->findById($delid);
                $file   = dirname(__FILE__)."/../webroot/".str_replace('../','',$timeline_content['SppTimelineContent']['title_banner']);              
                if(file_exists($file)) {
                    unlink($file);
                }
                
                $file   = dirname(__FILE__)."/../webroot/".str_replace('../','',$timeline_content['SppTimelineContent']['audio_file']);
                if(file_exists($file)) {
                    unlink($file);
                }

                if(empty($timeline_content)){
                    $this->render('/elements/error');
                }
        		$this->SppTimelineContent->delete($delid,true);
                $this->SppTopImage->deleteAll(array('id' => $delid), false);
                
        		$this->Session->setFlash(Configure::read('Message.DELETE_SUCCESS'));
        		return $this->redirect(array('action' => 'index'));
			}
        }

        $created_date_from  = '';
        $created_date_to    = '';
        $title              = '';
        $conditions = array();
        if ($this->RequestHandler->isPost()){
        	if(isset($this->data['submit_search'])){
				$created_date_from = $this->data['SppTimelineContent']['created_date_from'];
				$created_date_to = $this->data['SppTimelineContent']['created_date_to'];
				$title = $this->data['SppTimelineContent']['title'];
        	}
			
			$this->Session->write('timelineContent.date_from', $created_date_from);
			$this->Session->write('timelineContent.date_to', $created_date_to);
			$this->Session->write('timelineContent.title', $title);
        } else {
        	$created_date_from = $this->Session->read('timelineContent.date_from');
        	$created_date_to = $this->Session->read('timelineContent.date_to');
        	$title = $this->Session->read('timelineContent.title');
        }
        
        if(!empty($created_date_from)){
        	$conditions[] = "created_date >= '".date("Y-m-d", strtotime($created_date_from))."'";
        }
        if(!empty($created_date_to)){
        	$conditions[] = "created_date <= '".date("Y-m-d", strtotime($created_date_to))."'";
        }
        if(!empty($title)){
        	$conditions[] = "title LIKE '%".$title."%'";
        }
		
        $this->paginate = array(
        			'fields' => array('id', 'created_date', 'sort_order', 'title', 'is_free', 'is_public','expiration_date' ,'reservation_flag','viewed'),
        			'conditions' => $conditions,
				    'limit' => Configure::read('TIMELINE.NUMBER_OF_PAGE'),
					'order' => array('SppTimelineContent.created_date' =>'desc', 'sort_order' => 'asc'));
              
        $timeline_contents = $this->paginate('SppTimelineContent');
        $this->set(compact('timeline_contents'));
        $this->set(compact('created_date_from'));
        $this->set(compact('created_date_to'));
        $this->set(compact('title'));
    }

    function add()
    {
        $tag_list = $this->SppTag->find(
            'all', 
            array(
                'fields'        => array('tag_name','tag_image_path','id'),
            )
        );
    	$timelineContent = array();
    	if ($this->RequestHandler->isPost()){

    		$timelineContent['SppTimelineContent'] = $this->data['SppTimelineContent'];
    		$timelineContent['SppTimelineContent']['created_date']    = date("Y-m-d", strtotime($this->data['SppTimelineContent']['created_date']));
            if($this->data['SppTimelineContent']['expiration_date'] !=""){
                $timelineContent['SppTimelineContent']['expiration_date']  = date("Y-m-d", strtotime($this->data['SppTimelineContent']['expiration_date']));
            }else{
                $timelineContent['SppTimelineContent']['expiration_date'] = '0000-00-00';
            }           
            
    		if (!empty($this->data['audio_file']['name']) && $this->data['audio_file']['type'] != "audio/mp3") {
    			$this->Session->setFlash(Configure::read('Message.ERR_AUDIO_EXT'));
				$this->set(compact('timelineContent','tag_list'));
    			return;
    		}

            if (strlen($this->data['SppTimelineContent']['body_content']) > 2500) {
                $this->Session->setFlash(Configure::read('Message.ERR_CONTENT_LENGHT'));
                $this->set(compact('timelineContent','tag_list'));
                return;
            }
            
    		$is_error = false;
    		$current_time = date('Ymdhis', time());
    		$uploads_dir = Configure::read('IMG_TIMELINE_CONTENT');
    		if ( ! is_dir($uploads_dir)) {
    			mkdir($uploads_dir);
    		}

    		if (!empty($this->data['title_banner']) && is_uploaded_file($this->data['title_banner']['tmp_name'])) {
    			$path_parts = pathinfo($this->data['title_banner']['name']);
				$full_path = $uploads_dir.$current_time.".".$path_parts['extension'];
				if(move_uploaded_file($this->data['title_banner']['tmp_name'], $full_path)){
					$timelineContent['SppTimelineContent']['title_banner'] = '../'.$full_path;
                    //IS top                    
                    if($this->data['SppTimelineContent']['top_flag'] == 1){
                        $top_image_data['image_path'] = $timelineContent['SppTimelineContent']['title_banner'];
                    }
				} else {
					$is_error = true;
				}
    		}            

            //Upload mp3 file
            $uploads_dir = Configure::read('AUDIO_TIMELINE_CONTENT');
            if ( ! is_dir($uploads_dir)) {
                mkdir($uploads_dir);
            }
            if (!empty($this->data['audio_file']) && is_uploaded_file($this->data['audio_file']['tmp_name'])) {
                $path_parts = pathinfo($this->data['audio_file']['name']);
                $full_path = $uploads_dir.$current_time.".".$path_parts['extension'];
                if(move_uploaded_file($this->data['audio_file']['tmp_name'], $full_path)){
                    $timelineContent['SppTimelineContent']['audio_file'] = '../'.$full_path;
                } else {
                    $is_error = true;
                }
            }

            if (!isset($top_image_data) && $this->data['SppTimelineContent']['top_flag'] == 1) {
                $this->Session->setFlash(Configure::read('Message.ERR_TITLE_FILE_EMTPY'));
                $this->set(compact('timelineContent','tag_list'));
                return;
            }
            
            if ($this->data['SppTimelineContent']['tag_id'] == 0) {
                $this->Session->setFlash("タグを選択して下さい");
                $this->set(compact('timelineContent','tag_list'));
                return;
            }

    		if (!$is_error) {
                $save_success = $this->SppTimelineContent->save($timelineContent);
                if($save_success){

                    if(isset($top_image_data)){
                        $this->SppTopImage->deleteAll('1=1', false);
                        $top_image_data['id'] = $this->SppTimelineContent->getLastInsertID();
                        $this->SppTopImage->save($top_image_data);
                    }

                    $this->Session->setFlash(Configure::read('Message.ADD_SUCCESS'));
                    $this->set(compact('timelineContent'));
                    return $this->redirect(array('action' => 'index'));
                }else{
                    $this->Session->setFlash(Configure::read('Message.ERR_ADD'));
                }
    			
    		} else {
    			$this->Session->setFlash(Configure::read('Message.ERR_ADD'));
    		}
    	} else {
            //View Form
    		$timelineContent = $this->SppTimelineContent->create();
	    	$timelineContent['SppTimelineContent']['created_date']    = date('Y/m/d');
            $timelineContent['SppTimelineContent']['expiration_date'] = '';
	    	$timelineContent['SppTimelineContent']['sort_order']      = 1;
	    	$timelineContent['SppTimelineContent']['title']           = '';
	    	$timelineContent['SppTimelineContent']['body_content']    = '';  
            $timelineContent['SppTimelineContent']['is_public']       = 1;   		
    	}

        $tag_list = $this->SppTag->find(
            'all', 
            array(
                'fields'        => array('tag_name','tag_image_path','id'),
            )
        );

	    $this->set(compact('timelineContent','tag_list'));
    }

    function edit()
    {
        $tag_list = $this->SppTag->find(
            'all', 
            array(
                'fields'        => array('tag_name','tag_image_path','id'),
            )
        );
    	if(isset($this->params['url']['id'])){
    		$id = $this->params['url']['id'];
    		$timelineContent = $this->SppTimelineContent->findById($id);
    		if(empty($timelineContent)){
    			$this->render('/elements/error');
    		}

            if($timelineContent['SppTimelineContent']['expiration_date'] == '0000-00-00'){
                $timelineContent['SppTimelineContent']['expiration_date'] = "";
            }

    	} else {
    		$this->render('/elements/error');
    	}

    	if ($this->RequestHandler->isPost()){    		
    		$uploads_dir    = Configure::read('IMG_TIMELINE_CONTENT');
    		$current_time   = date('Ymdhis', time());
            $title_banner   = $timelineContent['SppTimelineContent']['title_banner'];
            $top_image_path = $title_banner;
            $will_unlink    = array();

    		$timelineContent['SppTimelineContent'] = $this->data['SppTimelineContent'];
    		$timelineContent['SppTimelineContent']['created_date'] = date("Y-m-d", strtotime($this->data['SppTimelineContent']['created_date']));

            if($this->data['SppTimelineContent']['expiration_date'] !=""){
                $timelineContent['SppTimelineContent']['expiration_date']  = date("Y-m-d", strtotime($this->data['SppTimelineContent']['expiration_date']));
            }else{
                $timelineContent['SppTimelineContent']['expiration_date'] = "0000-00-00";
            }

            //print_r($timelineContent['SppTimelineContent']);exit;
            
    		$is_error = false;
            
            if (strlen($this->data['SppTimelineContent']['body_content']) > 2500) {
                $this->Session->setFlash(Configure::read('Message.ERR_CONTENT_LENGHT'));
                $this->set(compact('timelineContent','tag_list'));
                return;
            }
        
    		if (!empty($this->data['title_banner']) &&
    			is_uploaded_file($this->data['title_banner']['tmp_name'])) {
    			
    			$path_parts = pathinfo($this->data['title_banner']['name']);
				$full_path = $uploads_dir.$current_time.".".$path_parts['extension'];
				if(move_uploaded_file($this->data['title_banner']['tmp_name'], $full_path)){
					$timelineContent['SppTimelineContent']['title_banner'] = '../'.$full_path;
                    $top_image_path = $timelineContent['SppTimelineContent']['title_banner'];
                    if(file_exists($title_banner)) {
                        $will_unlink[] = $title_banner;
                    }                    
				} else {
					$is_error = true;
				}
    		}

            $uploads_dir  = Configure::read('AUDIO_TIMELINE_CONTENT');
            $audio_file   = $timelineContent['SppTimelineContent']['audio_file'];
            if (!empty($this->data['audio_file']) &&
                is_uploaded_file($this->data['audio_file']['tmp_name'])) {
                
                $path_parts = pathinfo($this->data['audio_file']['name']);
                $full_path  = $uploads_dir.$current_time.".".$path_parts['extension'];
                if(move_uploaded_file($this->data['audio_file']['tmp_name'], $full_path)){
                    $timelineContent['SppTimelineContent']['audio_file'] = '../'.$full_path;
                    if(file_exists($audio_file)) {
                        $will_unlink[] = $audio_file;
                    }                
                } else {
                    $is_error = true;
                }
            }

            if ($top_image_path == "" && $this->data['SppTimelineContent']['top_flag'] == 1) {
                $this->Session->setFlash(Configure::read('Message.ERR_TITLE_FILE_EMTPY'));
                $this->set(compact('timelineContent','tag_list'));
                return;
            }

            if ($this->data['SppTimelineContent']['tag_id'] == 0) {
                $this->Session->setFlash("タグを選択して下さい");
                $this->set(compact('timelineContent','tag_list'));
                return;
            }

    		if (!$is_error && $this->SppTimelineContent->save($timelineContent)){
                
                //if have image && top = true
                if($top_image_path != "" && $this->data['SppTimelineContent']['top_flag'] == 1){
                    $this->SppTopImage->deleteAll('1=1', false);                    
                    $this->SppTopImage->save(array('id'=>$id,'image_path'=>$top_image_path));                    
                }else if($this->data['SppTimelineContent']['top_flag'] == 0){
                    $this->SppTopImage->deleteAll(array('id' => $id), false);
                }    

                if(count($will_unlink)){
                    foreach ($will_unlink as $link) {
                        $file   = dirname(__FILE__)."/../webroot/".str_replace('../','',$link);
                        unlink($link);
                    }
                }                                           

    			$this->Session->setFlash(Configure::read('Message.EDIT_SUCCESS'));
    			$this->set(compact('timelineContent','tag_list'));
	    		return $this->redirect(array('action' => 'index'));
    		} else {
    			$this->Session->setFlash(Configure::read('Message.ERR_EDIT'));
    		}
    	}

        $tag_list = $this->SppTag->find(
            'all', 
            array(
                'fields'        => array('tag_name','tag_image_path','id'),
            )
        );

    	$this->set(compact('timelineContent','tag_list'));
    }
}

?>
