<?php
class SppLicense extends AppModel {
	var $name = 'SppLicense';
	var $validate = array(
		'license_id' => array(
			'numeric' => array(
				'rule' => array('numeric', 'notempty'),
			),
		),
		'license_code' => array(
			'notempty' => array(
				'rule' => array( 'notempty'),
				
			),
		)
	);
	var $belongsTo = array(
		'SppUser' => array(
			'className' => 'SppUser',
			'foreignKey' => 'user_id',
			'order' => '',
		)
	);
	var $hasMany = array(
		'SppLicenseContent' => array(
			'className' => 'SppLicenseContent',
			'foreignKey' => 'license_id',
		)
	);
	

	/**
	 * Create random string
	 * input length of string
	 * output string
	 */
	function genRandomStringE()
	{
		$characters = '0123456789';
		$include_hyphen = Configure::read('LICENSE.INCLUDE_HYPHEN');
		$length = 8;
		$temp_length = Configure::read('LICENSE.LENGTH');
		if (!empty($temp_length)) {
			$length = $temp_length;
		}
		$temp_characters = Configure::read('LICENSE.CHARACTERS');
		if (!empty($temp_characters)) {
			$characters = $temp_characters;
		}
		$string = null;
		for ($p = 0; $p < $length; $p++) {
			if($include_hyphen == true && $p%4 == 0 && $p > 0){
				$string .= '-';
			}
			$string .= $characters[mt_rand(0, strlen($characters)-1)];
		}
		return $string;
	}
	
/**
	 * Check license code extis
	 * input int $licensecode
	 * output boolean. return true if its exits, else return false
	 */
	function checkLicenseCodeExit($licensecode = '')
	{
		$license = $this->find('first', array('conditions' => array('license_code' => $licensecode)));
		if (!empty($license[0]['SppLicense']['id'])) {
			return true;
		}
		return false;
	}
	
	function getLicensesByOrganization($organization_code){
		$joins = array();
		$joins[] = array(
            'table' => 'spp_learners',
            'alias' => 'SppLearner',
            'type' => 'left',
            'conditions' => array('SppLearner.id = SppLicense.learner_id')
		);
		$conditions = array();
		$conditions['SppLearner.organization_code']= $organization_code;
		$fields = "SppLicense.id";
		return $this->find('all',array(
					'fields' => $fields,
					'conditions' => $conditions,
					'joins' => $joins));
	}
	
	function getLicenseByLearnerId($learner_id){
		return $this->find('all',array(
					'conditions' => array('learner_id'=>$learner_id)));
	}
	
	function updateExpiredDate($license_code, $learner_id, $extend_days){
		if($extend_days == 0){
			return;
		}
		$conditions = array();
		if(!empty($license_code)){
			$conditions['license_code'] = $license_code;
		} else {
			if(!empty($learner_id)){
				$conditions['learner_id'] = $learner_id;
			} else {
				return;
			}
		}
		$license = $this->find('first',array('conditions' => $conditions));
		if(!empty($license)){
			$new_expire_date = strtotime("+".$extend_days." days", strtotime($license['SppLicense']['expired_end_date']));
			$license['SppLicense']['expired_end_date'] = date("Y-m-d", $new_expire_date);
			$this->save($license);
		}
	}
	
/**
	 *
	 * GET remaining days base on learner_id
	 * @param unknown_type $learner_id
	 */
	function getRemainingDays($learner_id){
		$remaining_days = 0;
		$expired_end_date = NULL;
		$license =  $this->find('first',array('conditions' => array('learner_id' => $learner_id)));
		if(!empty($license)){
			$expired_end_date = $license['SppLicense']['expired_end_date'];
			$datediff = strtotime($expired_end_date) - strtotime(date("Y-m-d"));
			$remaining_days = floor($datediff/(60*60*24)) + 1;
		}
		if($remaining_days < 0){
			$remaining_days = 0;
		}
		return $remaining_days;	
		//return $remaining_days;

	}
	
	function getExpiredEndDate($learner_id){
		$remaining_days = 0;
		$expired_end_date = "";
		$license =  $this->find('first',array('conditions' => array('learner_id' => $learner_id)));
		if(!empty($license)){
			$expired_end_date = $license['SppLicense']['expired_end_date'];
		}
		return str_replace("-","/",$expired_end_date);	
	}

	function checkLicenseValid($license) {
		if($license['SppLicense']['check_flag'] || empty($license['SppLicense']['client_used_date'])){
			return true;
		}
		return false;
	}
	
}
?>