<?php
class SppQuestion extends AppModel {
	var $name = "SppQuestion";

	function getListQuestions($include_answered, $created_date_from, $created_date_to, $learner_id, $first_name, $last_name, $org_code){
		$conditions = array();
		$joins = array();
		$joins[]= array(
            'table' => 'spp_learners',
            'alias' => 'SppLearner',
            'type' => 'left',
            'conditions' => array('SppLearner.id = SppQuestion.learner_id')
		);

		if(!empty($created_date_from)){
			$conditions['SppQuestion.created_datetime >= '] = $created_date_from->format('Y-m-d H:i:s');
		}
		if(!empty($created_date_to)){
			$conditions['SppQuestion.created_datetime <= '] = $created_date_to->format('Y-m-d H:i:s');
		}
		if(!empty($learner_id)){
			$conditions[] = "SppQuestion.learner_id LIKE '%".$learner_id."%'";
		}
		if(!empty($first_name)){
			$conditions['OR']= array("SppLearner.first_name LIKE '%".$first_name."%'", "SppLearner.first_name_kana LIKE '%".$first_name."%'" );
		}
		if(!empty($last_name)){
			$conditions['OR']= array("SppLearner.last_name LIKE '%".$last_name."%'", "SppLearner.last_name_kana LIKE '%".$last_name."%'" );
		}
		if(!$include_answered){
			$conditions['SppQuestion.answered_datetime'] = NULL;
		}
		if(!empty($org_code)){
			$conditions[] = "SppQuestion.learner_id in (SELECT spp_learners.id FROM spp_learners WHERE spp_learners.organization_code like '".$org_code."')";
		}

		$fields = "SppQuestion.id, SppQuestion.learner_id, SppQuestion.created_datetime,
				   SppQuestion.question_content, SppQuestion.answered_person, SppQuestion.answered_datetime,
				   SppQuestion.is_public, SppLearner.first_name, SppLearner.last_name";
		return array(
					'fields' => $fields,
				    'limit' => Configure::read('QUESTION.NUMBER_OF_PAGE'),
					'conditions' => $conditions,
					'joins' => $joins,
					'order' => array('SppQuestion.created_datetime' =>'desc'));
	}

	function getAllForCSV(){
		$joins = array();
		$joins[]= array(
            'table' => 'spp_learners',
            'alias' => 'SppLearner',
            'type' => 'left',
            'conditions' => array('SppLearner.id = SppQuestion.learner_id')
		);

		$fields = "SppQuestion.*, SppLearner.first_name, SppLearner.last_name";

		return $this->find('all',array(
					'fields' => $fields,
					'joins' => $joins,
					'order' => array('SppQuestion.created_datetime' =>'desc')));

	}

	function getQuestionById($question_id){
		$joins = array();
		$joins[]= array(
            'table' => 'spp_learners',
            'alias' => 'SppLearner',
            'type' => 'left',
            'conditions' => array('SppLearner.id = SppQuestion.learner_id')
		);
		$fields = "SppQuestion.id, SppQuestion.learner_id, SppQuestion.created_datetime, SppQuestion.category_name,
				   SppQuestion.subcategory_name, SppQuestion.quiz_no, SppQuestion.answered_content,
				   SppQuestion.mark, SppQuestion.question_content, SppQuestion.answered_person,
				   SppQuestion.answered_datetime, SppQuestion.original_is_public, SppQuestion.is_public, SppLearner.first_name, SppLearner.last_name";
		return $this->find('first',array(
					'fields' => $fields,
					'conditions' => array('SppQuestion.id' => $question_id),
					'joins' => $joins,
					'order' => array('SppQuestion.created_datetime' =>'desc')));
	}

	function countQuestionNotAnswer(){
		return $this->find('count',array(
					'conditions' => array('SppQuestion.answered_datetime is NULL')));
	}
}