CREATE TABLE IF NOT EXISTS `quizzes_for_searches` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content_id` int(11) NOT NULL,
  `category_no` int(11) NOT NULL,
  `category_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `subcategory_no` int(11) NOT NULL,
  `subcategory_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `quiz_no` int(11) NOT NULL,
  `quiz_keyword` text COLLATE utf8_unicode_ci NOT NULL,
  `quiz_set_times` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `quiz_classification` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `quiz_type` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `quiz_difficulty` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3393 ;

ALTER TABLE  `quizzs` ADD  `category_name` VARCHAR( 255 ) NOT NULL AFTER  `category_no`;
ALTER TABLE  `quizzs` ADD  `subcategory_name` VARCHAR( 255 ) NOT NULL AFTER  `subcategory_no`;

CREATE VIEW v_correct_rates AS
select ql.category_no, ql.subcategory_no, ql.quiz_no, ROUND((1 - SUM(ql.incorrect_count)/SUM(try_count))*100) AS correct_rate, l.organization_code, l.id as learner_id
from spp_quiz_logs AS ql left join spp_learners AS l ON ql.learner_id = l.id
GROUP BY ql.category_no, ql.subcategory_no, ql.quiz_no, l.id, l.organization_code;
