import config from './config.js';
import db     from './db.js';

export default class Record {
    find(categoryNo, quizNo) {
        return db.transaction('r', db.record, () => {
            return db.record
                .where('category_no').equals(categoryNo)
                .and((record) => record.quiz_no == quizNo)
                .first();
        });
    }

     /**
     * get total try count
     *
     * @param is_client_flg
     * @param category_no
     * @author  ChienNguyen
     * @updated 2019.01.11
     */

    getTotalTryCount(category_no, is_client_flg) {
        return db.transaction('r', db.record, async () => {
            if(category_no){
                return db.record
                .where('try_count').above(0)
                .and((record) => {
                    return (
                        record.category_no   == category_no
                    );
                })
                .filter((record) => {
                    if(is_client_flg){
                        return (
                            record.category_no >= 500 
                        );
                    }else
                    {
                        return true;
                    }
                })
                .count();
            }else{
                return db.record
                .where('try_count').above(0)
                .filter((record) => {
                    if(is_client_flg){
                        return (
                            record.category_no >= 500 
                        );
                    }else
                    {
                        return true;
                    }
                })
                .count();
            }
        });
    }

     /**
     * get total miss count
     *
     * @param is_client_flg
     * @param category_no
     * @author  ChienNguyen
     * @updated 2019.01.11
     */

    getTotalIncorrectCount(category_no) {
        return db.transaction('r', db.record, async () => {
            if(category_no){
                return db.record
                .where('last_answered').equals(0)
                .and((record) => record.try_count > 0)
                .and((record) => record.category_no == category_no)
                .count();
            }else{
                return db.record
                .where('last_answered').equals(0)
                .and((record) => record.try_count > 0)
                .count();
            }
        });
    }

    getTotalMissCount(category_no, is_client_flg) {
        return db.transaction('r', db.record, async () => {
            if(category_no){
                return db.record
                .where('last_answered').equals(0)
                .and((record) => record.try_count > 0)
                .and((record) => record.category_no == category_no)
                .filter((record) => {
                    if(is_client_flg){
                        return (
                            record.category_no >= 500 
                        );
                    }else
                    {
                        return true;
                    }
                })
                .count();
            }else{
                return db.record
                .where('last_answered').equals(0)
                .and((record) => record.try_count > 0)
                .filter((record) => {
                    if(is_client_flg){
                        return (
                            record.category_no >= 500 
                        );
                    }else
                    {
                        return true;
                    }
                })
                .count();
            }
        });
    }

    getTotalAchievementCount() {
        return db.transaction('r', db.record, async () => {
            return db.record
                .where('last_answered').equals(1)
                .count();
        });
    }

    getIncorrectQuizNumbers(category_no) {
        return db.transaction('r', db.record, async () => {
            let result_quizz = [];

            let records = await db.record
                .where('last_answered').equals(0)
                .and((record) => record.try_count > 0)
                .and((record) => record.category_no == category_no)
                .toArray((records) => {
                        return Promise.all(records.map(async (record) => {
                                // add 
                                result_quizz.push(record.quiz_no);
                            }));
                        });
            return result_quizz;
        });
    }
    /*
    * get quiz log is changed
    * 
    * @author ChienNguyen
    * @updated 2019.01.12
    */

    getQuizLogs() {
        return db.transaction('r', db.record, async () => {
            let result_list_quiz_log = [];

            let records = await db.record
                    .where('is_modify').equals(1)
                    .toArray((records) => {
                        return Promise.all(records.map(async (record) => {
                                // convert data
                                let selectbox = (record.selectbox == true) ? 1 : 0;
                                record.incorrect_count  = record.incorrect_count; 
                                record.last_answer      = record.last_answered;
                                record.selectbox        = selectbox;
                                record.answer           = true;
                                delete record.id;
                                // add 
                                result_list_quiz_log.push(record);
                            }));
                        });
            return result_list_quiz_log;
        });
    }

    /*
    * update is_modify for quiz log is submitted when save success
    * 
    * @author ChienNguyen
    * @updated 2019.01.19
    */

    updateQuizLogIsSubmitted() {
        return db.transaction('rw', db.record, async () => {
            await db.record.where("is_modify").equals(1).modify({is_modify: 0});
            return true;
        });
    }
}