import db from './db.js';

export default class Choice {
    find(categoryNo, subCategoryNo, quizNo) {
        return db.transaction('r', db.choices, async () => {
            var choices = await db.choices
                .where('category_no').equals(categoryNo)
                .and((choice) => choice.quiz_no == quizNo)
                .toArray();
            //  sort key choice_no
            if(choices.length)
            {
            	choices.sort(function(a,b) {
					return a.choice_no - b.choice_no;
				});
            }
            return choices;
        });
    }
}