const path = require('path');
const {InjectManifest} = require('workbox-webpack-plugin');
const BrowserSyncPlugin = require('browser-sync-webpack-plugin');
const CleanWebpackPlugin = require('clean-webpack-plugin');
const webpack = require("webpack");

module.exports = {
    entry: {
        app: './index.js',
    },
    output: {
        filename: '[name].bundle.js',
        path: path.join(__dirname, 'dist'),
        publicPath: 'dist/'
    },
    module: {
        rules: [
            {
                test: /\.hbs$/,
                exclude: /node_modules\/(?!(error-overlay-webpack-plugin)\/).*/,
                loader: 'handlebars-loader',
                options: {
                    helperDirs: path.join(__dirname, 'js/hbs-helper'),
                    rootRelative: './templates/',
                    extensions: [
                        ".hbs",
                    ],
                    partialDirs: [
                        path.join(__dirname, 'templates', 'partials')
                    ],
                },
            },
            {
                test: /\.js$/,
                exclude: /(node_modules|bower_components)/,
                use: {
                    loader: "babel-loader",
                    options: {
                        presets: ['@babel/preset-env']
                    }
                }
            }

        ],
    },
    resolve: {
        extensions: [
            '.js',
        ],
    },
    plugins: [
        new CleanWebpackPlugin([path.join(__dirname, 'dist')]),
        new InjectManifest({
            swSrc: path.join(__dirname, 'js/sw.js'),
            swDest: path.join(__dirname, 'sw.js'),
            exclude: [
                '.htaccess',
                'browserconfig.xml',
                /icon\/.*/,
                /template\/.*/,
            ],
            templatedUrls: {
                '/': '/pwa',
            }
        }),
        new BrowserSyncPlugin({
            host: 'localhost',
            port: 8080,
            files: ['*.index.html', 'css/*.css', 'js/*.js'],
            server: {baseDir: ['.']}
        }),
        new webpack.ProvidePlugin({
            $: "jquery",
            jQuery: "jquery",
            "window.jQuery": "jquery'",
            "window.$": "jquery"
        }),
    ],
    node: {
        fs: 'empty'
    }
};