const api_url = 'https://lec.pw-app.com/admin/gyosho2022/';     // Url connect to Doamin of server API
const url_root = 'https://lec-gyosho2022.pw-app.com';    // Url root of Doamin
const config = { 
    // If you can not use sub folder. Please input empty -
    // Else in put sub folder name  ex:"/pwa"
    'subfolder': '',

    'api_url': api_url,
    'url_api_login': api_url + 'sppserver/learnerLogin',
    'url_api_update': api_url + 'sppserver/updateLearnerInfo',
    'url_api_forget_pass': api_url + 'sppserver/forgetPassword',
    'url_api_logout': api_url + 'sppserver/learnerLogout',
    'url_api_syns_data': api_url + 'sppapicontent/Syncdata',
    'url_api_mypage_report': api_url + 'sppserver/saveStudyInfo',
    'url_api_get_ranks': api_url + 'sppserver/getRanks',
    'url_api_get_leraner_list_by_rank': api_url + 'sppserver/getLearnerListByRank',
    'url_api_get_top_100_this_week_learner': api_url + 'sppserver/getTop100ThisWeekLearner',
    'url_api_update_ver_data': api_url + 'sppapicontent/syncDataFromServer',
    'url_api_sync_data_quiz_log': api_url + 'sppapicontent/syncDataQuizLog',
    'url_api_message_data': api_url + 'sppserver/getMessageList',
    'url_api_device_login': api_url + 'sppserver/getInfoDeviceLogin',
    'url_api_update_device_token': api_url + 'sppserver/updateDeviceToken',
    'url_api_check_data_on_server': api_url + 'sppapicontent/checkDataStatusOnServer',
    'image_path': api_url + 'pwa_web/',

    'user_detail': '/user/detail',
    'user_message': '/user/message',
    'user_message_one': '/user/message-select',
    'user_config': '/user/configuration',
    'category_list': '/category/list-cat',
    'error_page': '/error_page',
    'forgot_password': '/user/forgot-password',

    'QUIZ_TYPE_YES_NO': 'QUIZ_TYPE_YES_NO',
    'QUIZ_TYPE_ONE_CHOICE': 'QUIZ_TYPE_ONE_CHOICE',
    'QUIZ_TYPE_MULTI_CHOICES': 'QUIZ_TYPE_MULTI_CHOICES',
    'QUIZ_TYPE_FILL_EMPTY': 'QUIZ_TYPE_FILL_EMPTY',
};


/*
* config value button menu on Page Top in ascending order
* @param name
* @param link
* @param icon
* Support is available for 6 menus
*/

config.menu = [
        {
            'name' : '学習を始める',
            'link' : config.subfolder + '/category/list-cat',
            'icon' : '/img/icon1.png' 
        },
        {
            'name' : 'Myページ',
            'link' : config.subfolder + '/mypage/report',
            'icon' : '/img/icon2.png' 
        },
        {
            'name' : 'サポート',
            'link' : 'https://lookon.jp/contact/',
            'icon' : '/img/icon3.png' 
        },
        {
            'name' : '弱点攻略',
            'link' : config.subfolder + '/incorrect/list-type',
            'icon' : '/img/icon4.png' 
        },
        {
            'name' : 'お知らせ・設定',
            'link' : config.subfolder + '/user/configuration',
            'icon' : '/img/icon6.png' 
        },
        {
            'name' : '',
            'link' : '',
            'icon' : '/img/icon0.png' 
        },
];

/*
* Setting limit min max and default value font size
* @param min
* @param max
* @param default
* 
*/

config.RANGE_FONT_SIZE = 
        {
            'min'     : 10,
            'max'     : 26,
            'default' : 18 
        }
;
/*
* setting funct 補足 for view quiz
* 
* Type boolean true or false
* if true will enable funct and vice versa
* default false
*/

config.FUNCTION_SUPPLEMENT = true;

/*
* Setting Database name
 */
config.DATE_NAME = "lec_gyosho2022";
config.DATE_NAME_FREE = "free_gyosho2022";

/*
* setting define page name overview all page
*
* @author ChienNguyen
*/

config.DEFINE_PAGE_NAME =
        {
            'HOME'                          : 'HOME',
            'CATEGORY_LIST_CATE'            : 'CATEGORY_LIST_CATE',
            'CATEGORY_LIST'                 : 'CATEGORY_LIST',
            'CATEGORY_NORMAL'               : 'CATEGORY_NORMAL' ,
            'CATEGORY_CONTINUE'             : 'CATEGORY_CONTINUE' ,
            'CATEGORY_INCORRECT'            : 'CATEGORY_INCORRECT' ,
            'CATEGORY_NOT_ANSWERED_YET'     : 'CATEGORY_NOT_ANSWERED_YET' ,
            'CATEGORY_BOOKMARK'             : 'CATEGORY_BOOKMARK' ,
            'CATEGORY_RANDOM'               : 'CATEGORY_RANDOM' ,
            'CATEGORY_RED_SHEET'            : 'CATEGORY_RED_SHEET' ,
            // quiz
            'QUIZ_ALL'                      : 'QUIZ_ALL' ,
            'QUIZ'                          : 'QUIZ' ,
            'QUIZ_ANSWER'                   : 'QUIZ_ANSWER',
            // user
            'USER_DETAIL'                   : 'USER_DETAIL',
            'USER_MESSAGE'                  : 'USER_MESSAGE',
            'USER_MESSAGE_ONE'              : 'USER_MESSAGE_ONE',
            'USER_CONFIG'                   : 'USER_CONFIG',
            'FORGOT_PASSWORD'               : 'FORGOT_PASSWORD',
            // mypage
            'MYPAGE_REPORT'                 : 'MYPAGE_REPORT',
            'MYPAGE_RANKING'                : 'MYPAGE_RANKING',
            'MYPAGE_SCORE'                  : 'MYPAGE_SCORE',
            // incorrect
            'INCORRECT_LIST_TYPE'           : 'INCORRECT_LIST_TYPE',
            'SUPPLEMENT'                    : 'SUPPLEMENT',
            'USERINFO'                      : 'USERINFO',

            'QUIZ_SEARCH'                   : 'QUIZ_SEARCH' ,

            //...
            'OTHER_PAGE'                    : 'OTHER_PAGE' ,

        }
;

/**
 * Setting message when select Mode Random & mode Sheet
 * @type {string}
 */
config.MGS_RED_SHEET = "赤シートがありません。";
config.MGS_BOOKMARK = "クリップがありません。";
config.MGS_NOT_YET_ANSWER = "未回答の問題はありません。";

/**
 * answer Status Learning Quiz
 */
config.ANSWER = {
    "RIGHT" : "right_answer@2x.png",
    "WRONG" : "wrong_answer@2x.png"
};

/**
 * Set indexdb limit MB
 */
config.DATA_LIMIT_MOBILE = {
    "MOTICATION"    : "保存容量の上限は",
    "MEG_OVERFLOW_DATA_LIMIT" : "容量不足で保存できません。\n" + "ブラウザのメモリを解放してください。\n" + "＊注意：メモリを解放する前にログアウトしてください",
    "MEMORY_INDEXDB" : 30,
    "INDEXDB_Opera" : 40,
    "INDEXDB_Chrome" : 50,
    "INDEXDB_Safari" : 50,
    "INDEXDB_Firefox" : 50,
    "INDEXDB_Edge" : 50,
};
config.DATA_LIMIT_DESKTOP = {
    "MOTICATION"    : "保存容量の上限は",
    "MEG_OVERFLOW_DATA_LIMIT" : "容量不足で保存できません。\n" + "ブラウザのメモリを解放してください。\n" + "＊注意：メモリを解放する前にログアウトしてください",
    "MEMORY_INDEXDB" : 30,
    "INDEXDB_Opera" : 40,
    "INDEXDB_Chrome" : 50,
    "INDEXDB_Safari" : 50,
    "INDEXDB_Firefox" : 50,
    "INDEXDB_Edge" : 50
};

config.MESSAGE_DEVIVE_LOGIN = "このアカウントは別のデバイスにログインされています。\n" + "ログインしますか？";
config.MESSAGE_DIFF_DEVIVE_LOGIN = "あなたのアカウントは別のデバイスにログインされているため、ログアウトされました。";
config.MESSAGE_UPDATE_DATE_AGAIN = "最新の学習データに同期します。";

/**
 * config message save study info
 */
config.MESSAGE_SAVE_STUDY = {
    "OK" : "保存を完了しました。",
    "NG" : "保存を失敗しました。"
};

/**
 * config message handle sync data
 */
config.MESSAGE_HANDLE_SYNC_DATA = {
    "CONFIRM" : "データの更新を行います",
    "OK" : "データ更新が成功しました。",
    "NG" : "データ更新が失敗しました。"
};

/**
 * config face_mark_flg
 *
 * IF true the enable funct face mark
 * Else false the disable funct face mark
 */
config.face_mark_flg = false;

/**
 * config list face mark
 */
config.LIST_FACE_MARK = [
    {
        "img_path"  : "img/btn_face_fine.png"
    },
    {
        "img_path"  : "img/btn_face_nomal.png"
    },
    {
        "img_path"  : "img/btn_face_sad.png"
    }
];

/**
 * config client_flg
 *
 * IF true it affect
 * - ランダムモード
 * - Myページの成績で表示するカテゴリーは、category_no >= 500のもの（項目別）のみとして下さい
 * - 弱点攻略の対象問題は、category_no >= 500 のもの（項目別）のみとして下さい。
 *
 * Else false the above features work normally
 */
config.client_flg = false;

/**
 * Config Message Forget password
 */
config.MESSAGE_FORGET_PASSWORD = "あなたのパスワードはリセットされました。メールを確認してください。" ;
config.MESSAGE_FORGET_PASSWORD_ERROR = "システムはメールが送信できません。";
config.MESSAGE_FORMAT_MAIL_ERROR = "メールアドレスが存在しません。";

/**
 * config auto save counts 
 *
 * if leaner answer 10 quiz then
 *  - auto save study info into server
 *
 * @updated 2019.01.15
 */
config.autoSaveCounts = 10;

/**
 * config disable change password & ID of USER
 * 1 disable
 * 0 Enable
 */
config.DISABLE_UPDATE_INFO_USER = 1;

/**
 * config part for content html
 */
config.PART_CONTENT_HTML = 
    {
        "CONTENT_HEADER"  : "contentHeader",
        "CONTENT_BODY"    : "contentBody",
        "CONTENT_FOOTER"  : "contentFooter",
        "CONTENT_COMMON"  : "contentCommon"
    }
;

/**
 * config version no
 */
config.version_no = 'Ver 1.0.0';

/**
 * Message notication network Offine
 */
config.NETWORK = {
    "OFFLINE_MYPAGE" : "サーバーエラーが発生しました。",
    "OFFLINE_PAGE" : "インターネットに接続できません。\n" + "後程やり直してください。"
}

export default config;
