import Dexie from 'dexie';
const $    = require('jquery');
import config from "./config";
import Login from "./login";

const db = new Dexie(config.DATE_NAME); // Create DATABASE for indexdb

db.version(1).stores({
    category: 'id, category_no, category_notation, category_name',

    choices: 'id, category_no, subcategory_no, quiz_no, choice_no, answer, content_id, face_mark',

    contents: 'content_id, content_id, name, content_type, purchase_type, state, version',

    progress_images: 'z_order, x, y, width, height, condition_1, condition_2, condition_3',

    quizzes: 'id, category_no, subcategory_no, quiz_no, sentence, comment, keyword, related_image_name, choice_row_count, answer_no, time_limit, rank, content_id', // Check again structuer old

    rankboxes: '++id, name, max_level',

    ranking: 'mode, category_no, date, point',

    record: 'id, category_no, subcategory_no, quiz_no, try_count, incorrect_count, last_answered, last_incorrect_count, selectbox, content_id, client_id, learner_id, face_marks, is_modify, category_name, subcategory_name, desc_answer, desc_answer_date',
    //record: 'id, category_no, subcategory_no, quiz_no, try_count, incorrect_count, last_answered, last_incorrect_count, selectbox, content_id, client_id, learner_id, face_marks, is_modify',

    related_images: 'name, data',

    selectboxes: '++id, default_name, name',

    sub_category: 'id, category_no, subcategory_no, subcategory_name, totalQuizOfSubCategory',

    subcontents: '++id, parent_content_id, content_id, name, version, state',

    top_incorrect_quizzes: 'content_id, category_no, category_name, subcategory_no, subcategory_name, quiz_no, incorrect_count',

    learning_logs: '++id, time_end, time_start, data, duration, submitted',

    user: 'id, first_name, last_name, first_name_kana, last_name_kana, nickname, email, password, organization_code, payment_status_id, learner_classification_id, created_datetime, updated_datetime',

    packaged_sync: 'id, content_type, content_code, content_name, sale_start_date, sale_end_date, builtin_flag, license_flag, store_flag, subscribe_flag, before_purchase_desc, after_purchase_desc, comment, active_flag, version, update_type, created_datetime, updated_datetime',
    
    continue_quiz: 'id, category_no, subcategory_no, quiz_no',

    message: '++id, created_datetime, delivery_date, id, learner_id, message, organization_code, rank_id, sender_id',

    random_quiz: '++id, category_no, subcategory_no, quiz_no, sentence, comment, keyword, related_image_name, choice_row_count, answer_no, time_limit, rank, content_id, status, local',

    random_incorrect: 'id, category_no, subcategory_no, quiz_no',
});

export default db;



